
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Dec 14 15:08:43 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief C2cription of this module
   *
   *  \version CRYS_ATP_TST_C2_MAIN.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */

/************* Include Files ****************/
#include "CRYS.h"

#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_ATP_TST_C2_Acceptance.h"

#include <stdio.h>


/************************ Defines ***********************/
/************************ Enums *************************/
/************************ Typedefs **********************/
/************************ Global Data *******************/
/************* Private function prototype ***************/
CRYSError_t CRYS_ATP_TST_C2_Acceptance_ALL_TESTS(void);
/************************ Public Functions ******************************/
void CRYS_ATP_TST_C2_main(void)
{
  DxUint8_t  Var;

  do
   {
     do
     {
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n\n--[ C2 tests Menu ]---------------------------------"));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [1] - Acceptance NON integrated            (ECB/CBC)   "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [2] - Acceptance Integrated                (ECB/CBC)   "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [3] - HASH NON integrated                              "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [4] - HASH Integrated                                  "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [5] - C2 One Way Function                              "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [T] - ALL C2 Acceptance tests                          "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [Z] - End of tests return to prev menu                 "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-----------------------------------------------------\n\n"));
             scanf("\n%c",&Var);
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Test = %c\n",Var));
             if (Var<='Z')
                      break;
             else
             {
                   ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
             }

      }while(1);


      switch(Var)
      {
        case '1':
            CRYS_ATP_TST_C2_Acceptance_NON_integrated();
            break;
        case '2':
            CRYS_ATP_TST_C2_Acceptance_Integrated();
            break;
        case '3':
            CRYS_ATP_TST_C2_HASH_Acceptance_NON_integrated();
          break;
        case '4':
            CRYS_ATP_TST_C2_HASH_Acceptance_Integrated();
          break;
        case '5':
            CRYS_ATP_TST_C2_Acceptance_OneWayFunc();
          break;
        case 'T':
            CRYS_ATP_TST_C2_Acceptance_ALL_TESTS();
            break;
        case 'Z':
              ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n End of C2 tests \n"));
                  break ;

           default:
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n*** Error in test selection [%c]\n",Var));
      }
         if(Var =='Z')
         break;
     }while (1);
}


/************************ Private Functions ******************************/
/*****************************************************************************
 * Function Name:
 *   CRYS_ATP_TST_C2_Acceptance_ALL_TESTS
 *
 * Inputs:
 *   none
 *
 * Outputs:
 *   CRYSError_t - Function error return
 *
 * C2cription:
 * This function runs all of the C2 Acceptance tests
 *
 ******************************************************************************/
CRYSError_t CRYS_ATP_TST_C2_Acceptance_ALL_TESTS(void)
{

    CRYSError_t        TST_Status = TESTPASS ,TST_TestStatus = TESTPASS;
    DxUint8_t          TST_DebugStatus = ATP_EXIT_TEST_AFTER_FAILURE;  

    TST_TestStatus = CRYS_ATP_TST_C2_Acceptance_NON_integrated();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }

    TST_TestStatus = CRYS_ATP_TST_C2_HASH_Acceptance_NON_integrated();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }

    TST_TestStatus = CRYS_ATP_TST_C2_Acceptance_Integrated();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }

  TST_TestStatus = CRYS_ATP_TST_C2_HASH_Acceptance_Integrated();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }

      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n \n******************************************************************\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"******************************************************************\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********* ALL OF THE C2 Acceptance TESTS PASS   :-)         *********\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"******************************************************************\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"******************************************************************\n"));

	  return TST_Status;

EXIT_ON_ERROR:
	  {
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE C2 TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
      
	  return DX_FAILURE;
	  }


    
}








